package gov.va.med.mhv.admin.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EmployeeDTO implements Serializable{
	
	private static final long serialVersionUID = -6534853832891741062L;
	
	private Long employeeId;
	private Integer oplock;
	private String comments;
	private String userName;
	private String firstName;
	private String lastName;
	private Date lastLoginDate;
	private Date currentLoginDate;
	private List<EmployeeOrgRoleDTO> employeeOrgRoles;
	
	
	public Long getEmployeeId() {
		return employeeId;
	}
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}
	public Integer getOplock() {
		return oplock;
	}
	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public Date getLastLoginDate() {
		return lastLoginDate;
	}
	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}
	public Date getCurrentLoginDate() {
		return currentLoginDate;
	}
	public void setCurrentLoginDate(Date currentLoginDate) {
		this.currentLoginDate = currentLoginDate;
	}
	public List<EmployeeOrgRoleDTO> getEmployeeOrgRoles() {
		return employeeOrgRoles;
	}
	public void setEmployeeOrgRoles(List<EmployeeOrgRoleDTO> employeeOrgRoles) {
		this.employeeOrgRoles = employeeOrgRoles;
	}
	
	public List<String> getUserRoles(){
		List<String> roles = new ArrayList<String>();
		List<EmployeeOrgRoleDTO> orgRoles=getEmployeeOrgRoles();
		if(orgRoles != null){
			for(EmployeeOrgRoleDTO orgRole: orgRoles){
				roles.add(orgRole.getRole().getName());
			}
		}
		return roles;
	}
	
	public List<String> getUserActiveRoles(){
		List<String> mhvroles = new ArrayList<String>();
		List<EmployeeOrgRoleDTO> orgRoles=getEmployeeOrgRoles();
		if(orgRoles != null){
			for(EmployeeOrgRoleDTO tempEmpOrgRole: orgRoles){
				if(tempEmpOrgRole != null && tempEmpOrgRole.getActive() == true) {
					if (tempEmpOrgRole.getRole().getName().equalsIgnoreCase("Role Administrator")) {
						if(tempEmpOrgRole.getOrganization().getTypeOfOrganization()
								.equalsIgnoreCase("Facility")) {
							//Facility Role Administrator
							mhvroles.add("Facility Role Administrator");
						}else if(tempEmpOrgRole.getOrganization().getTypeOfOrganization()
								.equalsIgnoreCase("National")) {
							//National Role Administrator
							mhvroles.add("National Role Administrator");
						}else if(tempEmpOrgRole.getOrganization().getTypeOfOrganization()
								.equalsIgnoreCase("VISN")) {
							//VISN Role Administrator
							mhvroles.add("VISN Role Administrator");
						}else if(tempEmpOrgRole.getOrganization().getTypeOfOrganization()
								.equalsIgnoreCase("Help Desk")) {
							//Help Desk Role Administrator
							mhvroles.add("Help Desk Role Administrator");
						}
					}else if (tempEmpOrgRole.getRole().getName().equalsIgnoreCase("Operator")) {
						mhvroles.add("Help Desk Operator");
					}else {
						mhvroles.add(tempEmpOrgRole.getRole().getName());
					}
					
				}
			}
		}
		if(mhvroles != null && mhvroles.size() > 0) {
			return mhvroles;
		}else {
			return null;
		}
	}
	
	public List<String> getUserOrgs(){
		List<String> orgs = new ArrayList<String>();
		List<EmployeeOrgRoleDTO> orgRoles=getEmployeeOrgRoles();
		if(orgRoles != null){
			for(EmployeeOrgRoleDTO orgRole: orgRoles){
				if(orgRole != null)
					orgs.add(orgRole.getOrganization().getName());
			}
		}
		return orgs;
	}
	
	public String getFullName() {
		String fullName = "";
		if (this.lastName != null) {
			fullName += this.lastName;
		}
		if (this.firstName != null) {
			fullName += ", ";
			fullName += this.firstName;
		}
		return fullName;
	}

	
}
